<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Return extends Model 
{

    protected $table = 'returns';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function items()
    {
        return $this->hasMany('App\Model\Item', 'return_id');
    }

    public function solutions()
    {
        return $this->hasMany('App\Model\Solution', 'return_id');
    }

    public function shippings()
    {
        return $this->hasMany('App\Model\Shipping', 'return_id');
    }

    public function messages()
    {
        return $this->hasMany('App\Model\Message', 'return_id');
    }

    public function attachments()
    {
        return $this->morphMany('App\Model\Attachment', 'owner');
    }

}